"""Reflex configuration file."""

import reflex as rx

config = rx.Config(
    app_name="website_analyzer",
    api_url="http://localhost:8000",
    frontend_port=3000,
    backend_port=8000,
    # Increase timeouts for long-running operations (scanning and LLM analysis)
    timeout=7200,  # 2 hour timeout for event handlers (default: 120)
    backend_timeout=7200,  # 2 hour timeout for backend operations (default: 120)
    # WebSocket settings to keep connection alive during long operations
    ping_timeout=600,  # 10 minutes for WebSocket ping timeout (default: 20)
    ping_interval=60,  # 1 minute between WebSocket pings (default: 20)
    show_built_with_reflex=False,
)
