# AI Scraper - Community Edition

This project is designed to run as a Docker image. 

## Step 1 - Copy example files

The community edition is missing the proprietary-folder containing the following files:

proprietary/credential.json
proprietary/prompt.txt
proprietary/questions.json

Copy these files from the examples-folder into the proprietary-folder and edit accordingly.

## Step 2 - Include logo

Add a logo to be shown in the header at the following path:

assets/logo.png

## Step 3 - Build image

To build the image, follow the following steps:

docker build -t <your_docker_hub_username>/ai_scraper

## Step 4 - Run container

Run the container using docker run or your hosting platform. Make sure to expose port 8080 as this is where the web application is listening on.

The following environment variables need to be set in the Docker container for the application to work:

- LOCAL_FILES_DIR       : Directory where files are stored that will to be persited between deploys. Mount a volume at this directory. Example: /local_files
- OPENAI_API_KEY        : Your OpenAI API key for LLM access
- QDRANT_API_KEY        : API Key of the Qdrant database
- QDRANT_PORT           : Port of the Qdrant database. Use 443 for self-hosted.
- QDRANT_URL            : URL of the Qdrant database. Example: https://qdrant-urhvne.amazonaws.com
- ADMIN_USER            : Username of the application user
- ADMIN_PASSWORD        : Password of the application user

Also make sure to mount a volume in your Docker container at the same directory wher LOCAL_FILES_DIR is pointing to.